#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const ll INF = (ll)4e18;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<ll> x(n), h(n);
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];

    vector<ll> ans(n, INF);

    // ----------------------------
    // 1) Levi najblizi visi jarbol
    // ----------------------------
    stack<int> st;
    for (int i = 0; i < n; i++) {
        while (!st.empty() && h[st.top()] < h[i])
            st.pop();
        if (!st.empty()) {
            int j = st.top();
            ans[i] = min(ans[i],
                llabs(x[i] - x[j]) + llabs(h[i] - h[j]));
        }
        st.push(i);
    }

    // ----------------------------
    // 2) Desni najblizi visi jarbol
    // ----------------------------
    while (!st.empty()) st.pop();
    for (int i = n - 1; i >= 0; i--) {
        while (!st.empty() && h[st.top()] < h[i])
            st.pop();
        if (!st.empty()) {
            int j = st.top();
            ans[i] = min(ans[i],
                llabs(x[i] - x[j]) + llabs(h[i] - h[j]));
        }
        st.push(i);
    }

    // ------------------------------------------------
    // 3) Kanapi (samo levi i desni susedni)
    // ------------------------------------------------
    auto check_rope = [&](int i, int L, int R) {
        // jarbol i, kanap izmedju L i R
        // tacka promene nagiba:
        double x0 = (x[L] + x[R] + h[R] - h[L]) / 2.0;
        double y0 = h[L] - (x0 - x[L]);

        // maksimalna visina na kanapu
        double maxH = max({(double)h[L], (double)h[R], y0});
        if (maxH < h[i]) return;

        // trazimo tacku sa y = h[i]
        // leva grana
        double xl = x[L] + (h[L] - h[i]);
        if (xl >= x[L] && xl <= x0) {
            double d = abs(xl - x[i]) + abs(h[i] - h[i]);
            ans[i] = min(ans[i], (ll)ceil(d));
        }

        // desna grana
        double xr = x0 + (h[i] - y0);
        if (xr >= x0 && xr <= x[R]) {
            double d = abs(xr - x[i]) + abs(h[i] - h[i]);
            ans[i] = min(ans[i], (ll)ceil(d));
        }
    };

    for (int i = 0; i < n; i++) {
        if (i > 0) check_rope(i, i - 1, i);
        if (i < n - 1) check_rope(i, i, i + 1);
    }

    // ----------------------------
    // Ispis
    // ----------------------------
    for (int i = 0; i < n; i++) {
        if (ans[i] == INF) cout << -1 << "\n";
        else cout << ans[i] << "\n";
    }

    return 0;
}